using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using System.IO;
public class CustomScrollingBackgrounds : MonoBehaviour {
	public int previousBGRamValue = 420;
    public Material CustomBackground;
	public GameObject CustomBackgroundGO;
	public List<Texture2D> CustomBGT2Ds = new List<Texture2D>();
	public string persistentDataPath;
	public string currentRomName;
	// Use this for initialization
	public IEnumerator OnScriptLoaded() {
		persistentDataPath = Application.dataPath + "/../";
		currentRomName = RxScriptInit.currentRomName;
        yield return new WaitForSeconds(0.5f);
        Debug.Log("CustomScrollingBackgrounds.cs Loaded! :)");
		CustomBackgroundGO = GameObject.Find("CustomBackground");
        CustomBackground = CustomBackgroundGO.GetComponent<Renderer>().material;
		DirectoryInfo rdir = new DirectoryInfo(persistentDataPath + "/Enhancements/" + currentRomName + "/-MyPackage-/");
        FileInfo[] CBGs = rdir.GetFiles("CustomBG*.png");
        foreach (FileInfo bg in CBGs)
        {
		FileStream fs = new FileStream(bg.FullName, FileMode.Open, FileAccess.Read);
        byte[] imageData = new byte[fs.Length];
        fs.Read(imageData, 0, (int)fs.Length);

        Texture2D tempT2D = new Texture2D(32, 32, TextureFormat.ARGB32, false);

        tempT2D.LoadImage(imageData);
		CustomBGT2Ds.Add(tempT2D);
		}
        CustomBackground.mainTexture = CustomBGT2Ds[0];
    }
	public void Update(){
		if (previousBGRamValue == 420){
			previousBGRamValue = (int)MyNes.NesEmu.mem_wram[1870]; // 1808?
		}
		if ((int)MyNes.NesEmu.mem_wram[1870] != previousBGRamValue){
			
			if ((int)MyNes.NesEmu.mem_wram[1870] == 001){
				CustomBackground.mainTexture = CustomBGT2Ds[0];
			}
			if ((int)MyNes.NesEmu.mem_wram[1870] == 002){
				CustomBackground.mainTexture = CustomBGT2Ds[1];
			}
			
		}
	}
}
